***********************************************************************
*** Figure D1 and Figure 4 in paper: Exuberance measures ***
***********************************************************************

clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures"        	
drop if year > 2012

twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "ESP" & year >=1980, ///
		title(Spain) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash)) 
        graph export EXUB_Spain.pdf, replace 				
			
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "NOR" & year >=1980, ///
		title(Norway) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Norway.pdf, replace 
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "SWE" & year >=1980, ///
		title(Sweden) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Sweden.pdf, replace 	
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "USA" & year >=1980, ///
		title(USA) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_USA.pdf, replace 	
		
* Appendix			
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "GBR" & year >=1980, ///
		title(UK) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_UK.pdf, replace 			  

				
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "AUS" & year >=1980, ///
		title(Australia) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Australia.pdf, replace 	
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "BEL" & year >=1980, ///
		title(Belgium) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Belgium.pdf, replace 	
		
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "CAN" & year >=1980, ///
		title(Canada) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Canada.pdf, replace 			
		
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "FIN" & year >=1980, ///
		title(Finland) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Finland.pdf, replace 			
		
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "FRA" & year >=1980, ///
		title(France) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_France.pdf, replace 			
				
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "DEU" & year >=1980, ///
		title(Germany) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Germany.pdf, replace 			
				

twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "ITA" & year >=1980, ///
		title(Italy) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Italy.pdf, replace 			

		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "JPN" & year >=1980, ///
		title(Japan) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Japan.pdf, replace 	
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "KOR" & year >=1980, ///
		title(Korea) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Korea.pdf, replace 
		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "NLD" & year >=1980, ///
		title(Netherlands) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Netherlands.pdf, replace 		

twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "CHE" & year >=1980, ///
		title(Switzerland) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Switzerland.pdf, replace 		

twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "AUT" & year >=1980, ///
		title(Austria) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Austria.pdf, replace 		
	
	
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "DNK" & year >=1980, ///
		title(Denmark) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Denmark.pdf, replace 	

		twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "GRC" & year >=1980, ///
		title(Greece) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Greece.pdf, replace 	

		
twoway (line exub_cred_g quarter, lpattern(dash)) (line exub_hp_inc quarter, yaxis(2) col("221 34 65")) if country == "PRT" & year >=1980, ///
		title(Portugal) ///
		xlabel(80(40)215, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		graphregion(color(white)) plotregion(lcolor(black) lpattern(solid))  ///
		yscale(range(-4 4)) yscale(range(-4 4) axis(2)) yscale(range(-4 4)) ylabel(-4(2)4) ylabel(-4(2)4, axis(2)) ///
		ytitle("") ytitle("", axis(2)) xtitle("") scale(1.4) legend(order(1 "Credit exuberance" 2 "House price exuberance") ring(0) rows(3)  pos(11) region(fcolor(none) lcolor(none))) yline(0, lcolor(black) lpattern(dash))
        graph export EXUB_Portugal.pdf, replace 
